#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"
#include "../generator.h"

//#define FOG_COLOR (0x888888)
#define FOG_COLOR (0x8080a0)
#define FLAQUE_X 28
#define FLAQUE_Y 23

static Obj3d *pFlaque;
static float Matrix[16], MatrixSrc[16];
static float SqrtTable[4096];

/*

  111111
  225533 -> yoh !
  444444

*/

#define FOND_Z 1.f
static GrVertex Fond1_1 = {0.f,0.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond1_2 = {640.f,0,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond1_3 = {640.,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond1_4 = {0,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static GrVertex Fond2_1 = {0.f,0.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond2_2 = {640.f,0,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond2_3 = {640.,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond2_4 = {0,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static GrVertex Fond3_1 = {0.f,0.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond3_2 = {640.f,0,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond3_3 = {640.,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond3_4 = {0,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static GrVertex Fond4_1 = {0.f,0.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond4_2 = {640.f,0,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond4_3 = {640.,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4_4 = {0,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static GrVertex Fond5_1 = {0.f,0.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond5_2 = {640.f,0,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond5_3 = {640.,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond5_4 = {0,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

void LInit_Flaque()
{
	int Cpt1;

	pFlaque = GenerateFloor(FLAQUE_X, FLAQUE_Y, 800, 600, 256, 256);
	PrepareTextureFromArray(g_PicPanneau, 256, 256, &g_TexturePanneau);
	BeIdentityMatrix(MatrixSrc);
	TranslateMatrix(MatrixSrc,0,0,800);

	for(Cpt1=0;Cpt1<sizeof(SqrtTable)/sizeof(float);Cpt1++)
		SqrtTable[Cpt1] = sqrt(Cpt1);
}

void QInit_Flaque()
{
	grSstControl(GR_CONTROL_ACTIVATE);

	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_LESS);
	grDepthMask(FXTRUE);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_NONE, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	grFogMode(GR_FOG_WITH_TABLE);
	grFogColorValue(FOG_COLOR);
	grFogTable(g_FogFlaque);

	g_demostate.ClearColor = FOG_COLOR;

	DownloadTexture(&g_TexturePanneau);
	SelectTexture(g_TexturePanneau);
	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grCullMode(GR_CULL_DISABLE);
}

void Effect_Flaque()
{
	int Cpt1, Cpt2;
	float x, y;
	float freq;
	FbVertex *pVertex;
	DWORD Cpt1Square;

	static DWORD dwCnt = 255;

	int Img1 = g_demostate.TickInEffect/15;

	x = (FLAQUE_X*5/10) + (FLAQUE_X*4/10) * (float)cos(Img1/42.f);
	y = (FLAQUE_Y*5/10) + (FLAQUE_Y*4/10) * (float)sin(Img1/32.f);
	freq = 1.f / (4.8f + 4 * (float)cos(Img1/31.f));

	pVertex = pFlaque->pVertexIn;

	for(Cpt1= 0;Cpt1<(FLAQUE_Y+1);Cpt1++)
	{
		Cpt1Square = (Cpt1-y)*(Cpt1-y);

		for(Cpt2= 0;Cpt2<(FLAQUE_X+1);Cpt2++)
		{
			(pVertex++)->z =
				(300.f)*CosTable[
				(DWORD)((SqrtTable[(DWORD)(Cpt1Square+(Cpt2-x)*(Cpt2-x)*16/9 )]*600+Img1*220))&8191
				];
		}
	}

	DrawWithMatrix(pFlaque, MatrixSrc, 0, 0, 0); // use Matrix for z-scope

}

void ByeBye_Flaque()
{
	FreeTexture(&g_TexturePanneau);
}
